//
//  B5Profile.h
//  ApplicationFrameworks
//
//  Created by Rick Fillion on 2015-04-15.
//
//

#import <OnePasswordDataModel/OnePasswordDataModel.h>

NS_ASSUME_NONNULL_BEGIN

@class OPSymmetricKey;
@class B5VaultAccess;
@class B5Category;
@class B5UserAccount;

FOUNDATION_EXPORT NSString *const B5VaultTypePersonal; // P
FOUNDATION_EXPORT NSString *const B5VaultTypeEveryone; // E
FOUNDATION_EXPORT NSString *const B5VaultTypeTemplate; // T
FOUNDATION_EXPORT NSString *const B5VaultTypeUserCreated; // U

@interface B5Profile : B5DatabaseObject <OPGenericProfile, OPServerProfile, NSSecureCoding>

//
// database properties
//
- (void)_setUUID:(NSString *)uuid;
@property (nonatomic, assign) OPID accountId;
@property (nonatomic, assign) NSUInteger keySerialNumber;
@property (nonatomic, assign) NSUInteger contentVersion;
@property (nonatomic, assign) NSUInteger metadataVersion;
@property (nonatomic, copy) NSString *vaultType; // enum?
@property (nonatomic, copy) NSDictionary *encryptedAttributes;

// Other
@property (readonly, assign) int64_t userACL;

@property (nonatomic, copy) OPImage * customIcon;
@property (nonatomic, copy) OPColor * profileColor;

@property (nonatomic, assign) BOOL tagsLoaded;

@property (nonatomic, copy, nullable) NSString * passwordHint;
@property (nonatomic, strong, nullable) NSData * iconData;
@property (nonatomic, strong, nullable) NSString * profileColorText;
@property (nonatomic, copy, nullable) NSString * lastUpdatedBy;
@property (nonatomic, copy) NSString * profileName;
@property (nonatomic, readonly, nullable) NSString *avatar;

// Populated by B5UserAccount as part of unlocking
@property (nonatomic, copy) NSString *accountName;

// Only available when unlocked. Specific to B5
@property (nonatomic, readonly) NSString *vaultName;

- (BOOL)unlockWithSymmetricKey:(OPSymmetricKey *)proposedMasterKey vaultAccess:(B5VaultAccess *)vaultAccess;
- (NSDictionary *)encryptWithMasterSymmetricKey:(NSData *)data error:(NSError **)error;
- (NSData *)decryptWithMasterSymmetricKey:(NSDictionary *)encryptedJSON error:(NSError **)error;

- (B5Category *)categoryWithUUID:(NSString *)uuid;
- (void)addCategory:(B5Category *)category;
- (void)removeCategoryWithUUID:(NSString *)uuid;

- (B5Category *)newLegacyCategoryWithUUID:(NSString *)categoryUUID; // Does not add the category to the profile automatically
- (B5Category *)newCategoryFromTemplate:(OPTemplate *)template; // does not add the category to the profile automatically
- (B5Category *)newSystemCategoryWithUUID:(nullable NSString *)categoryUUID; // Does not add the category to the profile automatically

- (instancetype)initNewWithUserAccount:(B5UserAccount *)userAccount;
- (instancetype)initExistingWithID:(OPID)oid userAccount:(B5UserAccount *)userAccount NS_DESIGNATED_INITIALIZER;

@end

NS_ASSUME_NONNULL_END
